/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.preferences.IAccountPageProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AccountsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.aptana.ui.accountsPreferencePage";
    private static final String EXTENSION_POINT_ID = "accountsPreferencePage";
    private static final String ELEMENT_PROVIDER = "provider";
    private static final String ATTR_CLASS = "class";
    private List<IAccountPageProvider> providers;
    private ProgressMonitorPart progressMonitorPart;

    public void init(IWorkbench workbench) {
        if (this.providers != null) {
            return;
        }
        this.providers = new ArrayList<IAccountPageProvider>();
        EclipseUtil.processConfigurationElements((String)"com.aptana.ui", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                String name = element.getName();
                if (AccountsPreferencePage.ELEMENT_PROVIDER.equals(name)) {
                    String className = element.getAttribute(AccountsPreferencePage.ATTR_CLASS);
                    if (StringUtil.isEmpty((String)className)) {
                        return;
                    }
                    try {
                        Object provider = element.createExecutableExtension(AccountsPreferencePage.ATTR_CLASS);
                        if (provider instanceof IAccountPageProvider) {
                            AccountsPreferencePage.this.providers.add((IAccountPageProvider)provider);
                        } else {
                            IdeLog.logError((Plugin)UIPlugin.getDefault(), (String)MessageFormat.format("The class {0} does not implement IAccountPageProvider", className));
                        }
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                    }
                }
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{AccountsPreferencePage.ELEMENT_PROVIDER});
            }
        });
        Collections.sort(this.providers, new Comparator<IAccountPageProvider>(){

            @Override
            public int compare(IAccountPageProvider provider1, IAccountPageProvider provider2) {
                return provider1.getPriority() - provider2.getPriority();
            }
        });
    }

    protected Control createContents(Composite parent) {
        final Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        main.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Composite accounts = new Composite(main, 0);
        accounts.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        accounts.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        IAccountPageProvider.IValidationListener listener = new IAccountPageProvider.IValidationListener(){

            public void preValidationStart() {
                AccountsPreferencePage.this.progressMonitorPart.setVisible(true);
                ((GridData)((AccountsPreferencePage)AccountsPreferencePage.this).progressMonitorPart.getLayoutData()).exclude = false;
                main.layout(true, true);
            }

            public void postValidationEnd() {
                if (!AccountsPreferencePage.this.progressMonitorPart.isDisposed()) {
                    AccountsPreferencePage.this.progressMonitorPart.setVisible(false);
                    ((GridData)((AccountsPreferencePage)AccountsPreferencePage.this).progressMonitorPart.getLayoutData()).exclude = true;
                    main.layout(true, true);
                }
            }
        };
        for (IAccountPageProvider provider : this.providers) {
            Control control = provider.createContents(accounts);
            control.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            provider.addValidationListener(listener);
        }
        this.progressMonitorPart = new ProgressMonitorPart(main, (Layout)GridLayoutFactory.fillDefaults().create());
        this.progressMonitorPart.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).exclude(true).create());
        for (IAccountPageProvider provider : this.providers) {
            provider.setProgressMonitor((IProgressMonitor)this.progressMonitorPart);
        }
        return main;
    }

    public boolean performCancel() {
        this.progressMonitorPart.setCanceled(true);
        return super.performCancel();
    }

    public boolean performOk() {
        for (IAccountPageProvider provider : this.providers) {
            if (provider.performOk()) continue;
            return false;
        }
        return true;
    }
}

